function copyToClipboard(text, button) {
    navigator.clipboard.writeText(text).then(function() {
        button.textContent = "Copied!";
        setTimeout(() => {
            button.textContent = "Click to copy";
        }, 2000);
    }, function(err) {
        console.error('Could not copy text: ', err);
    });
}

function downloadFile(url) {
    const link = document.createElement('a');
    link.href = url;
    link.download = url.substring(url.lastIndexOf('/') + 1);
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}

function downloadZip(url) {
    const link = document.createElement('a');
    link.href = url;
    link.download = url.substring(url.lastIndexOf('/') + 1);
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}

